package gov.va.med.mhv.sm.admin.enums;

public enum ReportingPeriodEnum {

	DAY (0L, "Day", "J"),
	WEEK (1L, "Week", "DAY"),
	MONTH (2L, "Month", "MON"),
	QUARTER (3L, "Quarter", "Q"),
	FISCAL_YEAR (4L, "Fiscal Year", "FY");

	private Long id;
	private String name;
	private String dbPeriod;
	
	private ReportingPeriodEnum(Long id, String name, String dbPeriod){
		this.id = id;
		this.name = name;
		this.dbPeriod = dbPeriod;
	}

	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getDbPeriod() {
		return dbPeriod;
	}
	public void setDbPeriod(String dbPeriod) {
		this.dbPeriod = dbPeriod;
	}
	public static ReportingPeriodEnum valueOf(Long value){
		for(ReportingPeriodEnum f : ReportingPeriodEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("No such reporting period found.");
	}

}
